(function($) {
    'use strict';

    $(document).ready(function() {
        var $apiKeyInput = $('#viewers-api-key');
        var $saveButton = $('#viewers-save-key');
        var $clearCacheButton = $('#viewers-clear-cache');
        var $statusContainer = $('#viewers-status');
        var $loading = $('#viewers-loading');
        var $lastUpdated = $('#viewers-last-updated');
        var $embedPreview = $('#viewers-embed-preview');

        // Show loading overlay
        function showLoading() {
            $loading.show();
        }

        // Hide loading overlay
        function hideLoading() {
            $loading.hide();
        }

        // Show status message
        function showStatus(type, message, note) {
            var iconClass = type === 'success' ? 'dashicons-yes-alt' : 'dashicons-warning';
            var noteHtml = note ? '<p class="viewers-com-note">' + note + '</p>' : '';
            
            var html = '<div class="viewers-com-notice ' + type + '">' +
                '<span class="dashicons ' + iconClass + '"></span>' +
                '<div>' +
                '<strong>' + message + '</strong>' +
                noteHtml +
                '</div>' +
                '</div>';
            
            $statusContainer.html(html);
            
            if (type === 'success') {
                $statusContainer.addClass('connected');
            } else {
                $statusContainer.removeClass('connected');
            }
        }

        // Save API key
        $saveButton.on('click', function() {
            var apiKey = $apiKeyInput.val().trim();
            
            if (!apiKey) {
                showStatus('error', 'Please enter an API key.');
                return;
            }
            
            showLoading();
            $saveButton.addClass('loading');
            
            $.ajax({
                url: viewersComAdmin.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'viewers_com_save_api_key',
                    nonce: viewersComAdmin.nonce,
                    api_key: apiKey
                },
                success: function(response) {
                    hideLoading();
                    $saveButton.removeClass('loading');
                    
                    if (response.success) {
                        showStatus(
                            'success',
                            'Connected to Viewers.com',
                            'Note: It can take a few minutes for new changes to start displaying on your site.'
                        );
                        
                        // Update the page to show embed status section
                        if (response.data.embed_code) {
                            // Reload page to show the new sections
                            location.reload();
                        }
                    } else {
                        showStatus('error', response.data.message || 'An error occurred.');
                    }
                },
                error: function() {
                    hideLoading();
                    $saveButton.removeClass('loading');
                    showStatus('error', 'An error occurred while connecting. Please try again.');
                }
            });
        });

        // Clear cache and recheck
        $clearCacheButton.on('click', function() {
            showLoading();
            $clearCacheButton.addClass('loading');
            
            $.ajax({
                url: viewersComAdmin.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'viewers_com_clear_cache',
                    nonce: viewersComAdmin.nonce
                },
                success: function(response) {
                    hideLoading();
                    $clearCacheButton.removeClass('loading');
                    
                    if (response.success) {
                        showStatus(
                            'success',
                            response.data.message,
                            'Note: It can take a few minutes for new changes to start displaying on your site.'
                        );
                        
                        // Update last updated time
                        if (response.data.last_updated) {
                            $lastUpdated.text(response.data.last_updated);
                        }
                        
                        // Update embed preview
                        if (response.data.embed_code) {
                            $embedPreview.text(response.data.embed_code);
                        }
                    } else {
                        showStatus('error', response.data.message || 'An error occurred.');
                    }
                },
                error: function() {
                    hideLoading();
                    $clearCacheButton.removeClass('loading');
                    showStatus('error', 'An error occurred while clearing cache. Please try again.');
                }
            });
        });

        // Allow Enter key to submit
        $apiKeyInput.on('keypress', function(e) {
            if (e.which === 13) {
                e.preventDefault();
                $saveButton.click();
            }
        });
    });
})(jQuery);











